/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.autoplot.AutoplotUtil;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.ThreadManager;
import org.autoplot.dom.Application;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomOps;
import org.das2.util.LoggerManager;
import org.jdesktop.layout.GroupLayout;

public class AggregateUrisDialog
extends JPanel {
    private final Application dom;
    private final DataSetSelector dataSetSelector;
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.gui");
    private JButton addressBarUriButton;
    private JButton allUrisButton;
    private JTextArea allUrisTA;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private DataSetSelector previewDataSetSelector;
    private JButton showWildcardsButton;

    public AggregateUrisDialog(Application dom, DataSetSelector sel) {
        this.initComponents();
        this.dom = dom;
        this.dataSetSelector = sel;
        this.previewDataSetSelector.setHidePlayButton(true);
        String s = this.dataSetSelector.getValue();
        String agg = DataSourceUtil.makeAggregation((String)s);
        if (agg != null) {
            this.previewDataSetSelector.setValue(agg);
        } else {
            this.jLabel5.setText(this.jLabel5.getText() + "  (Unable to create aggregation spec, couldn't find yyyymmdd.)");
            this.previewDataSetSelector.setValue(s);
        }
        Application dom2 = (Application)dom.copy();
        DomOps.aggregateAll(dom2);
        this.allUrisTA.setText("");
        for (DataSourceFilter dsf : dom2.getDataSourceFilters()) {
            if (dsf.getUri().startsWith("vap+internal:")) continue;
            this.allUrisTA.insert(dsf.getUri() + "\n", this.allUrisTA.getCaretPosition());
        }
        this.allUrisTA.setEditable(false);
        this.addressBarUriButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/go.png")));
        this.allUrisButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/go.png")));
    }

    public void showDialog() {
        Window window = SwingUtilities.getWindowAncestor((Component)this.dataSetSelector);
        final JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, "Aggregate URIs", true) : new JDialog((Dialog)window, "Aggregate URIs", true);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.add(this);
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        JButton cancel = new JButton("Cancel");
        cancel.setAction(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        cancel.setIcon(AutoplotUtil.cancelIcon());
        dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                dialog.setVisible(false);
                dialog.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        JButton help = new JButton("Help");
        help.setAction(new AbstractAction("Help"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoplotUtil.openBrowser("https://autoplot.org/help#Aggregation");
            }
        });
        buttons.add(help);
        buttons.add(cancel);
        buttons.add(new JLabel("   "));
        dialog.add((Component)this, "Center");
        dialog.add((Component)buttons, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanel2 = new JPanel();
        this.addressBarUriButton = new JButton();
        this.jLabel5 = new JLabel();
        this.allUrisButton = new JButton();
        this.jLabel6 = new JLabel();
        this.previewDataSetSelector = new DataSetSelector();
        this.jScrollPane1 = new JScrollPane();
        this.allUrisTA = new JTextArea();
        this.showWildcardsButton = new JButton();
        this.jLabel4.setText("<html>Autoplot has two ways of turning URIs of single files into aggregations that will combine data when the first dimension is time.  \nAn aggregation URI is one with wildcards (like $Y for year) that allows Autoplot to fetch multiple files to cover a time range.</html> ");
        this.jLabel4.setVerticalAlignment(1);
        this.addressBarUriButton.setText("Focus URI");
        this.addressBarUriButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AggregateUrisDialog.this.addressBarUriButtonActionPerformed(evt);
            }
        });
        this.jLabel5.setText("<html>Autoplot has attempted to make an aggregated URI from the focus URI.  Pressing the \"Focus URI\" button will accept the new URI:</html>");
        this.jLabel5.setVerticalAlignment(1);
        this.allUrisButton.setText("All URIs");
        this.allUrisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AggregateUrisDialog.this.allUrisButtonActionPerformed(evt);
            }
        });
        this.jLabel6.setText("<html>Autoplot has attempted to form aggregations for all the URIs on the canvas.  Pressing the \"All URIs\" button will accept these changes.  Here you can review the replacement URIs:</html>");
        this.jLabel6.setVerticalAlignment(1);
        this.allUrisTA.setColumns(20);
        this.allUrisTA.setRows(5);
        this.allUrisTA.setText("vap+dat:http://autoplot.org/data/autoplot.dat\n");
        this.jScrollPane1.setViewportView(this.allUrisTA);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 821, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add(1, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(24, 24, 24).add((Component)this.jScrollPane1, -1, 776, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add(1, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.allUrisButton, -2, 120, -2).addPreferredGap(0).add((Component)this.jLabel6, -2, 584, -2)).add(1, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(12, 12, 12).add((Component)this.previewDataSetSelector, -1, 776, Short.MAX_VALUE)).add(1, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.addressBarUriButton, -2, 123, -2).addPreferredGap(0).add((Component)this.jLabel5, -2, 580, -2))))).addContainerGap())));
        jPanel2Layout.linkSize(new Component[]{this.jLabel5, this.jLabel6}, 1);
        jPanel2Layout.linkSize(new Component[]{this.addressBarUriButton, this.allUrisButton}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 514, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.addressBarUriButton).add((Component)this.jLabel5, -2, -1, -2)).addPreferredGap(0).add((Component)this.previewDataSetSelector, -2, 39, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.allUrisButton).add((Component)this.jLabel6, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 367, Short.MAX_VALUE).addContainerGap())));
        this.showWildcardsButton.setText("Show Wildcards");
        this.showWildcardsButton.setToolTipText("Show wildcards in browser");
        this.showWildcardsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AggregateUrisDialog.this.showWildcardsButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(690, Short.MAX_VALUE).add((Component)this.showWildcardsButton).addContainerGap()).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4, -2, 664, -2).addContainerGap(136, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.showWildcardsButton).add(37, 37, 37).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4, -2, 77, -2).addContainerGap(501, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
    }

    private void addressBarUriButtonActionPerformed(ActionEvent evt) {
        final Application dom2 = (Application)this.dom.copy();
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        String newUri = this.previewDataSetSelector.getValue();
        int f = -1;
        DataSourceFilter[] dsfs = this.dom.getDataSourceFilters();
        for (int i = 0; i < dsfs.length; ++i) {
            if (dsfs[i] != dsf) continue;
            f = i;
        }
        if (f == -1) {
            throw new IllegalArgumentException("bad state ..");
        }
        dom2.getDataSourceFilters(f).setUri(newUri);
        this.dataSetSelector.setValue(newUri);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataSourceFilter[] dsfs;
                AggregateUrisDialog.this.dom.syncTo(dom2);
                for (DataSourceFilter dsf : dsfs = AggregateUrisDialog.this.dom.getDataSourceFilters()) {
                    dsf.getController().update();
                    AggregateUrisDialog.this.dom.getController().getApplicationModel().addRecent(dsf.getUri());
                }
            }
        };
        if (!ThreadManager.getInstance().run(run, "aggregateUris")) {
            JOptionPane.showMessageDialog(this, "Operation is currently busy.");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.getWindowAncestor(AggregateUrisDialog.this).setVisible(false);
            }
        });
    }

    private void allUrisButtonActionPerformed(ActionEvent evt) {
        final Application dom2 = (Application)this.dom.copy();
        DomOps.aggregateAll(dom2);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataSourceFilter[] dsfs;
                AggregateUrisDialog.this.dom.syncTo(dom2);
                for (DataSourceFilter dsf : dsfs = AggregateUrisDialog.this.dom.getDataSourceFilters()) {
                    if (dsf.getUri().equals("vap+internal:")) {
                        logger.fine("skipping vap+internal:");
                        continue;
                    }
                    dsf.getController().update();
                    AggregateUrisDialog.this.dom.getController().getApplicationModel().addRecent(dsf.getUri());
                }
                DataSourceFilter dsf = AggregateUrisDialog.this.dom.getController().getDataSourceFilter();
                if (dsf != null) {
                    String newUri = dsf.getUri();
                    AggregateUrisDialog.this.dataSetSelector.setValue(newUri);
                }
            }
        };
        if (!ThreadManager.getInstance().run(run, "aggregateUris")) {
            JOptionPane.showConfirmDialog(this, "Operation is currently busy.");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.getWindowAncestor(AggregateUrisDialog.this).setVisible(false);
            }
        });
    }

    private void showWildcardsButtonActionPerformed(ActionEvent evt) {
        AutoplotUtil.openBrowser("https://github.com/autoplot/documentation/blob/main/md/help.md#wildcard-codes");
    }
}

